#include "StdAfx.h"
#include "CommandData.h"
#include "StrOps.h"
//#include "..\p4api\include\p4\clientapi.h"
//#include "..\p4bridge\p4Base.h"
//#include "..\p4bridge\P4BridgeClient.h"


CommandData::CommandData(void)
{
	Cmd = NULL;
	Params = NULL;
	ParamCnt = 0;
	Tagged = 0;
}

CommandData::CommandData( char* nCmd, char** nFlags, int nFlagsCnt, char** nParams, int nParamCnt, int nTagged)
{
	Cmd = StrOps::StrDup(nCmd);
	Tagged = nTagged;

	Params = NULL;

	ParamCnt = nParamCnt + nFlagsCnt;
	if (ParamCnt > 0)
	{
		Params = new char*[ParamCnt];

		for (int idx = 0; idx < nFlagsCnt; idx++)
		{
			Params[idx] = StrOps::StrDup(nFlags[idx]);
		}

		for (int idx = 0; idx < nParamCnt; idx++)
		{
			Params[nFlagsCnt+idx] = StrOps::StrDup(nParams[idx]);
		}
	}
}

void CommandData::PrettyPrint( )
{
	printf( "p4%s %s", Tagged?" -Ztag":"", Cmd);

	if (Params != NULL)
	{
		for (int idx = 0; idx < ParamCnt; idx++)
		{
			if (idx > 3)
			{
				printf( " ...[%d parameters]", ParamCnt);
				break;
			}
			printf( " %s", Params[idx]);
		}
	}
}

CommandData::~CommandData(void)
{
	if (Cmd != NULL)
	{
		delete[] Cmd;
	}
	if (Params != NULL)
	{
		for (int idx = 0; idx < ParamCnt; idx++)
		{
			delete[] Params[idx];
		}
		delete[] Params;
	}
}

int CommandData::Run(P4BridgeServer* pSrvr, int cmdId)
{
	int success = RunCommand( pSrvr, Cmd, cmdId, Tagged, Params, ParamCnt );

	printf("%X ", cmdId);

	if (!success)
	{ 
		printf("Command Failed!: ");
	}
	PrettyPrint();
	printf( "\r\n");

	ClientInfoMsg * infoOut = GetInfoResults( pSrvr, cmdId);
	if (infoOut)
	{
		printf("%s\r\n", infoOut->Message);
	}

	P4ClientError* pErr = GetErrorResults( pSrvr, cmdId);
	while (pErr)
	{
		const char * msg = Message( pErr );
		if (msg)
		{
			printf("%s\r\n", msg);
		}
		pErr = Next( pErr );
	}

	return success;
}

